/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1843;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class BookCopyAttribute
implements ItemAttribute {
    private int generation;

    public BookCopyAttribute(int generation) {
        this.generation = generation;
    }

    private static int extractGeneration(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && stack.method_7909() instanceof class_1843) {
            return nbt.method_10550("generation");
        }
        return -1;
    }

    @Override
    public boolean appliesTo(class_1799 itemStack, class_1937 level) {
        return BookCopyAttribute.extractGeneration(itemStack) == this.generation;
    }

    @Override
    public String getTranslationKey() {
        return switch (this.generation) {
            case 0 -> "book_copy_original";
            case 1 -> "book_copy_first";
            case 2 -> "book_copy_second";
            default -> "book_copy_tattered";
        };
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.BOOK_COPY;
    }

    @Override
    public void save(class_2487 nbt) {
        nbt.method_10569("generation", this.generation);
    }

    @Override
    public void load(class_2487 nbt) {
        this.generation = nbt.method_10550("generation");
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new BookCopyAttribute(-1);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            int generation = BookCopyAttribute.extractGeneration(stack);
            if (generation >= 0) {
                list.add(new BookCopyAttribute(generation));
            }
            return list;
        }
    }
}

